#include "Structures.h"

std::istream& operator>>(std::istream& in, Node& node) 
{
    in >> node.NodeId;
    in >> node.coordinates[0] 
        >> node.coordinates[1] 
        >> node.coordinates[2];
    in >> node.isVertex;
    return in;
}

std::ostream& operator<<(std::ostream& out, const Node& node) 
{
    out << std::setw(4) << node.NodeId << " |"
        << std::right << std::setw(11) << node.coordinates[0] << std::setw(11) << node.coordinates[1] << std::setw(11) << node.coordinates[2]
        << " | " << node.isVertex << "\n";
    return out;
}

std::istream& operator>>(std::istream& in, FiniteElement& FE) 
{
    in >> FE.FEId;
    in >> FE.MaterialId;
    in >> FE.FiniteElementIdList[0] 
        >> FE.FiniteElementIdList[1] 
        >> FE.FiniteElementIdList[2];
    return in;
}

std::ostream& operator<<(std::ostream& out, const FiniteElement& FE) 
{
    out << std::setw(4) << FE.FEId << " |"
        << std::setw(11) << FE.MaterialId << " |";
    for (const auto& nodes_ID_it : FE.FiniteElementIdList)
        out << std::right << std::setw(4) << nodes_ID_it;
    out << "\n";
    return out;
}


std::istream& operator>>(std::istream& in, BoundaryFiniteElement& BFE) 
{
    in >> BFE.BFEId;
    in >> BFE.boundaryId;
    in >> BFE.FiniteElementIdList[0] 
        >> BFE.FiniteElementIdList[1]
        >> BFE.FiniteElementIdList[2]
        >> BFE.FiniteElementIdList[3];
    return in;
}

std::ostream& operator<<(std::ostream& out, const BoundaryFiniteElement& BFE) 
{
    out << std::setw(9) << BFE.BFEId << " |"
        << std::setw(9) << BFE.boundaryId << " |";
    for (const auto& nodes_ID_it : BFE.FiniteElementIdList)
        out << std::right << std::setw(4) << nodes_ID_it;
    out << "\n";
    return out;
}

Node::Node(int nodeId, const std::array<double, 3>& nodeCoordinates, bool isVertex1):
    NodeId(nodeId),
    coordinates(nodeCoordinates),
    isVertex(isVertex1)
{}

Edge::Edge(size_t a, size_t b) : 
    nodePair(std::make_pair(a, b)) 
{}

void Edge::setCenter(size_t newMiddleNode)
{
    centerNode = newMiddleNode;
}

bool Edge::operator==(const Edge& a) const 
{
    return (nodePair.first == a.nodePair.first) && (nodePair.second == a.nodePair.second);
}

std::ostream& operator<<(std::ostream& out_stream, const std::vector<Node>& VectorOfNodes) 
{
    out_stream << VectorOfNodes.size() << (VectorOfNodes.size() > 1 ? " Nodes:\n" : " Node:\n") << " ID"
        << std::setw(10) << "X" << std::setw(11) << "Y" << std::setw(11) << "Z" << std::setw(14) << "Vertex\n";
    for (const auto& it : VectorOfNodes)
        out_stream << it;
    return out_stream;
}

std::ostream& operator<<(std::ostream& out_stream, const std::vector<FiniteElement>& VectorOfFE) 
{
    int elements_size = VectorOfFE.size();
    out_stream << elements_size << (elements_size > 1 ? " FiniteElements:\n" : " FiniteElement:\n")
        << " ID" << std::setw(15) << "Material_ID" << std::setw(15) << "Nodes ID\n";
    for (const auto& it : VectorOfFE)
        out_stream << it;
    return out_stream;
}

std::ostream& operator<<(std::ostream& out, const std::vector<BoundaryFiniteElement>& VectorOfBFE) 
{
    int surfaces_size = VectorOfBFE.size();
    out << surfaces_size << (surfaces_size > 1 ? " BoundaryFiniteElements:\n" : " BoundaryFiniteElement:\n")
        << "Surface_ID" << std::setw(12) << "Boundary_ID" << std::setw(14) << "Nodes ID\n";
    for (const auto& it : VectorOfBFE)
        out << it;
    return out;
}
